' ------------------------
' Hardware-Inventarisierung via WMI
' Beispiel fr die iX
' Autor: Holger.Schwichtenberg@windows-scripting.de
' Mehr Infos zu Scripting und WMI auf http://www.windows-scripting.de
' ------------------------

' ### Konstanten
Const EINGABEDATEI = "h:\medien\ixwmi\code\computerliste.txt"
Const AUSGABEDATEI = "h:\medien\ixwmi\code\inventarliste.txt"
Const flagLINIEN = True

' ### Globale Variablen
Dim FSO ' Instanz von Scripting.FileSystemObject



' ### Inventarisierung Hauptprogramm

Dim computer ' Name des Computers
Dim ergebnis ' Ergebnismenge in Form eines WbemScripting.SWbemObjectSet
Dim objTX    ' Textdatei-Objekt fr die Liste der zu durchsuchenden Computer

' --- Global bentigtes Objekt
Set FSO = CreateObject("Scripting.FileSystemObject")

' --- Auslesen der Computerliste
Set objTX = FSO.OpenTextFile(EINGABEDATEI)

Do While Not objTX.AtEndOfStream
    computer = objTX.ReadLine
    If flagLINIEN Then say "====================================="
    If flagLINIEN Then say "Computer: " & computer
    If flagLINIEN Then say "====================================="
    Set ergebnis = wmiabfrage(computer, "select name,CurrentClockSpeed,L2CacheSize from Win32_Processor")
    ausgabe ergebnis
    Set ergebnis = wmiabfrage(computer, "select caption from Win32_VideoController")
    ausgabe ergebnis
    Set ergebnis = wmiabfrage(computer, "select caption from Win32_SoundDevice")
    ausgabe ergebnis
    Set ergebnis = wmiabfrage(computer, "select caption,size from Win32_DiskDrive")
    ausgabe ergebnis
    Set ergebnis = wmiabfrage(computer, "select caption from Win32_TapeDrive")
    ausgabe ergebnis
    Set ergebnis = wmiabfrage(computer, "select caption from Win32_NetworkAdapter where adaptertype='Ethernet 802.3'")
    ausgabe ergebnis
Loop



' ### Ausfhrung einer WQL-Abfrage auf einem bestimmten Rechner
Function wmiabfrage(computer, query)
Dim objServ ' WbemScripting.SWbemServices
Dim objOSet ' WbemScripting.SWbemObjectSet
Dim Anzahl  ' Anzahl der Ergebnisse
Set objServ = GetObject("winmgmts://" & computer & "\root\cimv2")
Set objOSet = objServ.ExecQuery(query)
On Error Resume Next
Anzahl = objOSet.Count
If Err.Number <> 0 Then
    say "!!!Fehler in der Abfrage: " & query
    Set wmiabfrage = Nothing
Else
    Set wmiabfrage = objOSet
End If
End Function



' --- Ausgabe des Abfrageergebnisses
Sub ausgabe(objOSet) ' objOSet As WbemScripting.SWbemObjectSet
Dim objWO ' Laufvariable fr SWbemObject
Dim headline ' Ausgabezeile berschrift
Dim line ' Ausgabezeil Gerte
Dim a '  Zhler
' --- Abfangen, da Ergebnismenge fehlerhaft oder leer war!
If objOSet Is Nothing Or objOSet.Count = 0 Then Exit Sub
a = 1
' --- Iteration ber alle MOs
For Each objWO In objOSet
  If a = 1 Then ' Ausgabe der berschrift!
    ' --- berschrift der ersten drei Spalten
    headline = "Computer;Hardwaretyp;Nr"
    For Each objprop In objWO.Properties_
      If objprop.Name <> "DeviceID" Then headline = headline & ";" & objprop.Name
    Next
    say headline
    headline = ""
  End If
  ' --- Ausgabe des Inhalt
  line = objWO.Path_.Server & ";" & objWO.Path_.Class & ";" & a
  For Each objprop In objWO.Properties_
    If objprop.Name <> "DeviceID" Then line = line & ";" & flat(objprop.Value)
  Next
  say line
  line = ""
  a = a + 1
Next
If flagLINIEN Then say "----"
End Sub


' ### Ausgabe erzeugen
Sub say(s)
wscript.echo s
WriteTo AUSGABEDATEI, s
End Sub

' ### Anhngen eines Strings an Datei
Sub WriteTo(FilePath, text)
Dim oTX ' As Scripting.TextStream
'On Error Resume Next
Set oTX = FSO.OpenTextFile(FilePath, 8, True)  ' 8 = ForAppending
oTX.WriteLine text
oTX.Close
On Error GoTo 0
End Sub

' ### Hilfsroutine: Macht aus einem Array einen CSV-String
Function flat(var) ' as String
On Error Resume Next
Dim i ' As Integer
If IsArray(var) Then ' Array flachklopfen
    flat = Join(var, ";")
Else                ' War kein Array
    flat = var
End If
End Function


' #### Weitere Beispiele, die nicht zum Tool dazugehren
Sub samples()
Dim objWO

Set objServ = GetObject("winmgmts:")
Set objOSet = objServ.ExecQuery("Select * from Win32_logicaldisk")
wmi_ListOSet objOSet

Set objWO = GetObject("winmgmts:Win32_logicaldisk.DeviceID='C:'")
wmi_ListO objWO

Set objWO = GetObject("winmgmts:\\sonne2000\root\cimv2:Win32_logicaldisk.DeviceID='C:'")
wmi_ListO objWO

Set objServ = GetObject("winmgmts:")
Set objWO = objServ.Get("Win32_logicaldisk='C:'")
wmi_ListO objWO

UserName = "Administrator"
Password = "xxx"
Namespace = "root\CIMV2"
Server = "Sonne2000"
Set objLoc = CreateObject("WbemScripting.SWbemLocator")
Set objServ = objLoc.ConnectServer(Server, Namespace, UserName, Password)

End Sub